/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.formatter;

import com.aptana.editor.xml.formatter.nodes.FormatterXMLContentNode;
import com.aptana.editor.xml.formatter.nodes.FormatterXMLElementNode;
import com.aptana.editor.xml.formatter.nodes.FormatterXMLVoidElementNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.FormatterBlockNode;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.FormatterBlockWithBeginNode;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.xml.core.parsing.ast.XMLCDATANode;
import com.aptana.xml.core.parsing.ast.XMLElementNode;
import com.aptana.xml.core.parsing.ast.XMLNode;
import com.aptana.xml.core.parsing.ast.XMLNodeType;

public class XMLFormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    private FormatterDocument document;

    public IFormatterContainerNode build(IParseNode parseResult, FormatterDocument document) {
        this.document = document;
        FormatterBlockNode rootNode = new FormatterBlockNode((IFormatterDocument)document);
        this.start((IFormatterContainerNode)rootNode);
        IParseNode[] children = parseResult.getChildren();
        this.addNodes(children);
        this.checkedPop((IFormatterContainerNode)rootNode, document.getLength());
        if (parseResult instanceof IParseRootNode) {
            this.setOffOnRegions(this.resolveOffOnRegions((IParseRootNode)parseResult, (IFormatterDocument)document, "xml.formatter.formatter.on.off.enabled", "xml.formatter.formatter.off", "xml.formatter.formatter.on"));
        }
        return rootNode;
    }

    private void addNodes(IParseNode[] children) {
        if (children == null || children.length == 0) {
            return;
        }
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            this.addNode(child);
            ++n2;
        }
    }

    private void addNode(IParseNode node) {
        XMLNode xmlNode = (XMLNode)node;
        if (xmlNode.getNodeType() == XMLNodeType.ELEMENT.getIndex()) {
            if (((XMLElementNode)xmlNode).isSelfClosing()) {
                this.pushFormatterVoidNode((XMLElementNode)xmlNode);
            } else {
                this.pushFormatterElementNode((XMLElementNode)xmlNode);
            }
        } else {
            xmlNode.getNodeType();
            XMLNodeType.DECLARATION.getIndex();
        }
    }

    private FormatterBlockWithBeginNode pushFormatterVoidNode(XMLElementNode node) {
        String type = node.getName().toLowerCase();
        FormatterXMLVoidElementNode formatterNode = new FormatterXMLVoidElementNode((IFormatterDocument)this.document, type);
        formatterNode.setBegin(XMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)node.getStartingOffset(), (int)(node.getEndingOffset() + 1)));
        this.push((IFormatterContainerNode)formatterNode);
        this.checkedPop((IFormatterContainerNode)formatterNode, -1);
        return formatterNode;
    }

    private FormatterBlockWithBeginEndNode pushFormatterElementNode(XMLElementNode node) {
        IParseNode[] children;
        String type = node.getName().toLowerCase();
        boolean hasNonTextChildren = false;
        IParseNode[] iParseNodeArray = children = node.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            if (!(child instanceof XMLCDATANode)) {
                hasNonTextChildren = true;
            }
            ++n2;
        }
        FormatterXMLElementNode formatterNode = new FormatterXMLElementNode((IFormatterDocument)this.document, type, hasNonTextChildren);
        formatterNode.setBegin(XMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)node.getStartingOffset(), (int)(node.getStartTagEndOffset() + 1)));
        this.push((IFormatterContainerNode)formatterNode);
        int endOffset = this.getOpenTagOffset(node.getEndingOffset(), this.document);
        int previousCloseTagOffset = this.getPreviousCloseTagOffset(endOffset, this.document);
        if (node.getChildCount() <= 1) {
            int textEndOffset;
            int textStartOffset = this.getBeginWithoutWhiteSpaces(previousCloseTagOffset + 1, this.document);
            if (textStartOffset > (textEndOffset = this.getEndWithoutWhiteSpaces(endOffset - 1, this.document))) {
                if (textStartOffset == endOffset) {
                    textEndOffset = textStartOffset - 1;
                } else {
                    textStartOffset = previousCloseTagOffset + 1;
                    textEndOffset = endOffset - 1;
                }
            }
            FormatterXMLContentNode contentFormatterNode = new FormatterXMLContentNode((IFormatterDocument)this.document, type, textStartOffset, textEndOffset + 1);
            formatterNode.addChild((IFormatterNode)contentFormatterNode);
        }
        this.addNodes(node.getChildren());
        if (node.getChildCount() <= 1) {
            this.checkedPop((IFormatterContainerNode)formatterNode, -1);
        } else {
            this.checkedPop((IFormatterContainerNode)formatterNode, endOffset);
        }
        formatterNode.setEnd(XMLFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)endOffset, (int)(node.getEndingOffset() + 1)));
        return formatterNode;
    }

    private int getOpenTagOffset(int offset, FormatterDocument document) {
        while (offset > 0) {
            if (document.charAt(offset) == '<') break;
            --offset;
        }
        return offset;
    }

    private int getPreviousCloseTagOffset(int offset, FormatterDocument document) {
        while (offset > 0) {
            if (document.charAt(offset) == '>') break;
            --offset;
        }
        return offset;
    }

    private int getBeginWithoutWhiteSpaces(int offset, FormatterDocument document) {
        int length = document.getLength();
        while (offset < length) {
            if (!Character.isWhitespace(document.charAt(offset))) break;
            ++offset;
        }
        return offset;
    }

    private int getEndWithoutWhiteSpaces(int offset, FormatterDocument document) {
        while (offset > 0) {
            if (!Character.isWhitespace(document.charAt(offset))) break;
            --offset;
        }
        return offset;
    }
}

